/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.g.GideonsSacrificeEffectReplacementEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class GideonsSacrificeEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent("creature or planeswalker you controls");

    GideonsSacrificeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose a creature or planeswalker you control. All damage that would be dealt this turn to you and permanents you control is dealt to the chosen permanent instead.";
    }

    private GideonsSacrificeEffect(GideonsSacrificeEffect effect) {
        super((OneShotEffect)effect);
    }

    public GideonsSacrificeEffect copy() {
        return new GideonsSacrificeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(filter);
        target.withNotTarget(true);
        if (!player.choose(this.outcome, (Target)target, source, game)) {
            return false;
        }
        game.addEffect((ContinuousEffect)new GideonsSacrificeEffectReplacementEffect(new MageObjectReference(target.getFirstTarget(), game)), source);
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.PLANESWALKER.getPredicate(), (Predicate)CardType.CREATURE.getPredicate()));
    }
}

