/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.ExchangeControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GildedDrakeEffect
extends OneShotEffect {
    GildedDrakeEffect() {
        super(Outcome.GainControl);
        this.staticText = "exchange control of {this} and up to one target creature an opponent controls. If you don't or can't make an exchange, sacrifice {this}. This ability still resolves if its target becomes illegal";
    }

    private GildedDrakeEffect(GildedDrakeEffect effect) {
        super((OneShotEffect)effect);
    }

    public GildedDrakeEffect copy() {
        return new GildedDrakeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent sourceObject = game.getPermanent(source.getSourceId());
        if (sourceObject == null) {
            return false;
        }
        if (this.getTargetPointer().getFirst(game, source) == null || game.getPermanent(this.getTargetPointer().getFirst(game, source)) == null) {
            sourceObject.sacrifice(source, game);
            return true;
        }
        ExchangeControlTargetEffect effect = new ExchangeControlTargetEffect(Duration.EndOfGame, "", true);
        effect.setTargetPointer(this.getTargetPointer().copy());
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

