/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetImpl;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.RandomUtil;

class GilgameshMasterAtArmsAttachEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.SAMURAI);

    GilgameshMasterAtArmsAttachEffect(Collection<Permanent> permanents, Game game) {
        super(Outcome.Benefit);
        this.staticText = "you may attach one of them to a Samurai you control";
        this.setTargetPointer((TargetPointer)new FixedTargets(permanents, game));
    }

    private GilgameshMasterAtArmsAttachEffect(GilgameshMasterAtArmsAttachEffect effect) {
        super((OneShotEffect)effect);
    }

    public GilgameshMasterAtArmsAttachEffect copy() {
        return new GilgameshMasterAtArmsAttachEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Set permanents = this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (player == null || permanents.isEmpty()) {
            return false;
        }
        Permanent samurai = Optional.of(new TargetPermanent(0, 1, filter, true)).map(t -> {
            player.choose(this.outcome, (Target)t, source, game);
            return t;
        }).map(TargetImpl::getFirstTarget).map(arg_0 -> ((Game)game).getPermanent(arg_0)).orElse(null);
        if (samurai == null) {
            return false;
        }
        switch (permanents.size()) {
            case 0: {
                return false;
            }
            case 1: {
                return samurai.addAttachment(((Permanent)RandomUtil.randomFromCollection(permanents)).getId(), source, game);
            }
        }
        FilterPermanent filterPermanent = new FilterPermanent("Equipment");
        filterPermanent.add((Predicate)new PermanentReferenceInCollectionPredicate(permanents, game));
        return Optional.of(new TargetPermanent(0, 1, filterPermanent, true)).map(t -> {
            player.choose(this.outcome, (Target)t, source, game);
            return t;
        }).map(TargetImpl::getFirstTarget).map(arg_0 -> ((Game)game).getPermanent(arg_0)).map(equipment -> samurai.addAttachment(equipment.getId(), source, game)).orElse(false);
    }
}

