/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ClashEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.ElfWarriorToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GiltLeafAmbushCreateTokenEffect
extends OneShotEffect {
    GiltLeafAmbushCreateTokenEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create two 1/1 green Elf Warrior creature tokens. Clash with an opponent. If you win, those creatures gain deathtouch until end of turn";
    }

    private GiltLeafAmbushCreateTokenEffect(GiltLeafAmbushCreateTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public GiltLeafAmbushCreateTokenEffect copy() {
        return new GiltLeafAmbushCreateTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CreateTokenEffect effect = new CreateTokenEffect((Token)new ElfWarriorToken(), 2);
            effect.apply(game, source);
            if (new ClashEffect().apply(game, source)) {
                for (UUID tokenId : effect.getLastAddedTokenIds()) {
                    Permanent token = game.getPermanent(tokenId);
                    if (token == null) continue;
                    GainAbilityTargetEffect continuousEffect = new GainAbilityTargetEffect((Ability)DeathtouchAbility.getInstance(), Duration.EndOfTurn);
                    continuousEffect.setTargetPointer((TargetPointer)new FixedTarget(tokenId));
                    game.addEffect((ContinuousEffect)continuousEffect, source);
                }
            }
            return true;
        }
        return false;
    }
}

