/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.PermanentToken;
import mage.players.Player;
import mage.util.CardUtil;

class GisaGloriousResurrectorExileEffect
extends ReplacementEffectImpl {
    GisaGloriousResurrectorExileEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Exile);
        this.staticText = "if a creature an opponent controls would die, exile it instead";
    }

    private GisaGloriousResurrectorExileEffect(GisaGloriousResurrectorExileEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public GisaGloriousResurrectorExileEffect copy() {
        return new GisaGloriousResurrectorExileEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getTarget() instanceof PermanentToken) {
            return player.moveCards((Card)zEvent.getTarget(), Zone.EXILED, source, game);
        }
        game.getState().setValue("GisaGloriousResurrectorExile" + source.getSourceId().toString() + game.getState().getZoneChangeCounter(source.getSourceId()), (Object)source);
        return player.moveCardsToExile((Card)zEvent.getTarget(), source, game, false, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.isDiesEvent() && zEvent.getTarget() != null && zEvent.getTarget().isCreature(game) && game.getOpponents(zEvent.getTarget().getControllerId()).contains(source.getControllerId());
    }
}

