/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.LifelinkAbility;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GixsCommandCounterEffect
extends OneShotEffect {
    GixsCommandCounterEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Put two +1/+1 counters on up to one creature. It gains lifelink until end of turn.";
    }

    private GixsCommandCounterEffect(GixsCommandCounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public GixsCommandCounterEffect copy() {
        return new GixsCommandCounterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCreaturePermanent target = new TargetCreaturePermanent(0, 1);
        target.withNotTarget(true);
        controller.chooseTarget(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        permanent.addCounters(CounterType.P1P1.createInstance(2), source, game);
        GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)LifelinkAbility.getInstance());
        effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

