/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class GixsCommandReturnEffect
extends OneShotEffect {
    GixsCommandReturnEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return up to two creature cards from your graveyard to your hand";
    }

    private GixsCommandReturnEffect(GixsCommandReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public GixsCommandReturnEffect copy() {
        return new GixsCommandReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 2, (FilterCard)StaticFilters.FILTER_CARD_CREATURES_YOUR_GRAVEYARD, true);
        controller.chooseTarget(this.outcome, (Target)target, source, game);
        return controller.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.HAND, source, game);
    }
}

