/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.VariableCostImpl;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.common.TapTargetCost;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.target.common.TargetControlledPermanent;

class GlacianPowerstoneEngineerCost
extends VariableCostImpl {
    private static final FilterControlledPermanent filter = new FilterControlledArtifactPermanent("untapped artifacts you control");

    GlacianPowerstoneEngineerCost() {
        super(VariableCostType.NORMAL, "controlled untapped artifacts you would like to tap");
        this.text = "Tap X untapped artifacts you control";
    }

    private GlacianPowerstoneEngineerCost(GlacianPowerstoneEngineerCost cost) {
        super((VariableCostImpl)cost);
    }

    public GlacianPowerstoneEngineerCost copy() {
        return new GlacianPowerstoneEngineerCost(this);
    }

    public int getMaxValue(Ability source, Game game) {
        return game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game);
    }

    public Cost getFixedCostsFromAnnouncedValue(int xValue) {
        return new TapTargetCost(new TargetControlledPermanent(xValue, xValue, filter, true));
    }

    static {
        filter.add((Predicate)TappedPredicate.UNTAPPED);
    }
}

