/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class GlacianPowerstoneEngineerEffect
extends OneShotEffect {
    GlacianPowerstoneEngineerEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top X cards of your library. Put one of those cards into your hand and the rest into your graveyard";
    }

    private GlacianPowerstoneEngineerEffect(GlacianPowerstoneEngineerEffect effect) {
        super((OneShotEffect)effect);
    }

    public GlacianPowerstoneEngineerEffect copy() {
        return new GlacianPowerstoneEngineerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (xValue < 1) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, xValue));
        if (cards.isEmpty()) {
            return false;
        }
        TargetCardInLibrary targetCard = new TargetCardInLibrary(1, StaticFilters.FILTER_CARD);
        player.choose(this.outcome, (Cards)cards, (TargetCard)targetCard, source, game);
        Card card = game.getCard(targetCard.getFirstTarget());
        if (card != null && player.moveCards(card, Zone.HAND, source, game)) {
            cards.remove(card);
        }
        player.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        return true;
    }
}

