/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.cost.CastFromHandForFreeEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;

class GlamdringEffect
extends OneShotEffect {
    GlamdringEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may cast an instant or sorcery spell from your hand with mana value less than or equal to that damage without paying its mana cost";
    }

    private GlamdringEffect(GlamdringEffect effect) {
        super((OneShotEffect)effect);
    }

    public GlamdringEffect copy() {
        return new GlamdringEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        FilterInstantOrSorceryCard filter = new FilterInstantOrSorceryCard("an instant or sorcery spell from your hand with mana value less than or equal to that damage");
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.OR_LESS, SavedDamageValue.MUCH.calculate(game, source, (Effect)this)));
        return new CastFromHandForFreeEffect((FilterCard)filter).apply(game, source);
    }
}

