/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class GloomCostIncreaseEffect
extends CostModificationEffectImpl {
    GloomCostIncreaseEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.staticText = "Activated abilities of white enchantments cost {3} more to activate.";
    }

    private GloomCostIncreaseEffect(GloomCostIncreaseEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.increaseCost((Ability)abilityToModify, (int)3);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!abilityToModify.isActivatedAbility()) {
            return false;
        }
        Permanent permanent = game.getPermanent(abilityToModify.getSourceId());
        return permanent != null && permanent.isEnchantment(game) && permanent.getColor(game).isWhite();
    }

    public GloomCostIncreaseEffect copy() {
        return new GloomCostIncreaseEffect(this);
    }
}

