/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GloomlanceEffect
extends OneShotEffect {
    GloomlanceEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target creature. If that creature was green or white, its controller discards a card";
    }

    private GloomlanceEffect(GloomlanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public GloomlanceEffect copy() {
        return new GloomlanceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetCreature != null) {
            Player targetController = game.getPlayer(targetCreature.getControllerId());
            targetCreature.destroy(source, game, false);
            Permanent destroyedCreature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
            if ((destroyedCreature.getColor(game).isGreen() || destroyedCreature.getColor(game).isWhite()) && targetController != null) {
                targetController.discard(1, false, false, source, game);
                return true;
            }
        }
        return false;
    }
}

