/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class GloomshriekerEffect
extends ReplacementEffectImpl {
    GloomshriekerEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If {this} would die, exile it instead";
    }

    private GloomshriekerEffect(GloomshriekerEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public GloomshriekerEffect copy() {
        return new GloomshriekerEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getSourceId()) && ((ZoneChangeEvent)event).isDiesEvent();
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ((ZoneChangeEvent)event).setToZone(Zone.EXILED);
        return false;
    }
}

