/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetAtBeginningOfNextEndStepEffect;
import mage.abilities.effects.common.PreventDamageToTargetEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.BlockingPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class GlyphOfDestruction
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("blocking Wall you control");

    public GlyphOfDestruction(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{R}");
        this.getSpellAbility().addEffect((Effect)new BoostTargetEffect(10, 0, Duration.EndOfCombat));
        this.getSpellAbility().addEffect((Effect)new PreventDamageToTargetEffect(Duration.EndOfTurn, Integer.MAX_VALUE).setText("Prevent all damage that would be dealt to it this turn"));
        this.getSpellAbility().addEffect((Effect)new DestroyTargetAtBeginningOfNextEndStepEffect().setText("Destroy it at the beginning of the next end step"));
        this.getSpellAbility().addTarget((Target)new TargetPermanent(filter));
    }

    private GlyphOfDestruction(GlyphOfDestruction card) {
        super((CardImpl)card);
    }

    public GlyphOfDestruction copy() {
        return new GlyphOfDestruction(this);
    }

    static {
        filter.add((Predicate)SubType.WALL.getPredicate());
        filter.add((Predicate)BlockingPredicate.instance);
    }
}

