/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.CardType;
import mage.constants.TargetController;
import mage.filter.FilterSpell;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;
import mage.target.Target;
import mage.target.TargetSpell;

class GoblinArtisansTarget
extends TargetSpell {
    private static final FilterSpell filterSpell = new FilterSpell("target artifact spell you control that isn't the target of an ability from another creature named Goblin Artisans");

    GoblinArtisansTarget() {
        super(filterSpell);
    }

    private GoblinArtisansTarget(GoblinArtisansTarget target) {
        super((TargetSpell)target);
    }

    public GoblinArtisansTarget copy() {
        return new GoblinArtisansTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        MageObjectReference sourceRef = new MageObjectReference(source.getSourceObject(game), game);
        Spell spell = game.getSpell(id);
        if (spell == null) {
            return false;
        }
        for (StackObject stackObject : game.getStack()) {
            Permanent permanent;
            if (!(stackObject instanceof StackAbility) || (permanent = ((StackAbility)stackObject).getSourcePermanentOrLKI(game)) == null || sourceRef.refersTo((MageObject)permanent, game) || !permanent.isCreature(game) || !"Goblin Artisans".equals(permanent.getName())) continue;
            if (!stackObject.getStackAbility().getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).anyMatch(id::equals)) continue;
            return false;
        }
        return true;
    }

    static {
        filterSpell.add((Predicate)CardType.ARTIFACT.getPredicate());
        filterSpell.add((ObjectSourcePlayerPredicate)TargetController.YOU.getOwnerPredicate());
    }
}

