/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.effects.common.counter.RemoveCounterSourceEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GoblinBombEffect
extends OneShotEffect {
    GoblinBombEffect() {
        super(Outcome.Damage);
        this.staticText = "flip a coin. If you win the flip, put a fuse counter on {this}. If you lose the flip, remove a fuse counter from {this}";
    }

    private GoblinBombEffect(GoblinBombEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller != null && permanent != null) {
            if (controller.flipCoin(source, game, true)) {
                game.informPlayers("Goblin Bomb: Won flip. Put a fuse counter on Goblin Bomb.");
                new AddCountersSourceEffect(CounterType.FUSE.createInstance(1)).apply(game, source);
                return true;
            }
            game.informPlayers("Goblin Bomb: Lost flip. Remove a fuse counter from Goblin Bomb.");
            new RemoveCounterSourceEffect(CounterType.FUSE.createInstance(1)).apply(game, source);
            return true;
        }
        return false;
    }

    public GoblinBombEffect copy() {
        return new GoblinBombEffect(this);
    }
}

