/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class GoblinGoliathDamageEffect
extends ReplacementEffectImpl {
    GoblinGoliathDamageEffect() {
        super(Duration.EndOfTurn, Outcome.Damage);
        this.staticText = "If a source you control would deal damage to an opponent this turn, it deals double that damage to that player instead.";
    }

    private GoblinGoliathDamageEffect(GoblinGoliathDamageEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public GoblinGoliathDamageEffect copy() {
        return new GoblinGoliathDamageEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        UUID sourceControllerID = source.getControllerId();
        UUID damageControllerID = game.getControllerId(event.getSourceId());
        UUID damageTargetID = event.getTargetId();
        return sourceControllerID != null && damageControllerID != null && damageTargetID != null && damageControllerID.equals(sourceControllerID) && game.getOpponents(sourceControllerID).contains(damageTargetID);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

