/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class GoblinMachinistEffect
extends OneShotEffect {
    GoblinMachinistEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Reveal cards from the top of your library until you reveal a nonland card. {this} gets +X/+0 until end of turn, where X is that card's mana value. Put the revealed cards on the bottom of your library in any order";
    }

    private GoblinMachinistEffect(GoblinMachinistEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoblinMachinistEffect copy() {
        return new GoblinMachinistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl cards = new CardsImpl();
            for (Card card : controller.getLibrary().getCards(game)) {
                if (card == null) continue;
                cards.add(card);
                if (card.isLand(game)) continue;
                if (card.getManaValue() <= 0) break;
                game.addEffect((ContinuousEffect)new BoostSourceEffect(card.getManaValue(), 0, Duration.EndOfTurn), source);
                break;
            }
            controller.revealCards(source, (Cards)cards, game);
            controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, true);
            return true;
        }
        return false;
    }
}

