/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GoblinTinkererDamageEffect
extends OneShotEffect {
    public GoblinTinkererDamageEffect() {
        super(Outcome.Detriment);
        this.staticText = "That artifact deals damage equal to its mana value to {this}";
    }

    private GoblinTinkererDamageEffect(GoblinTinkererDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoblinTinkererDamageEffect copy() {
        return new GoblinTinkererDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent targetArtifact = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (controller != null && targetArtifact != null) {
            Permanent sourceObject = game.getPermanent(source.getSourceId());
            int damage = targetArtifact.getManaValue();
            if (sourceObject != null && damage > 0) {
                sourceObject.damage(damage, targetArtifact.getId(), source, game, false, true);
            }
            return true;
        }
        return false;
    }
}

