/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class GodEternalBontuEffect
extends OneShotEffect {
    GodEternalBontuEffect() {
        super(Outcome.Benefit);
        this.staticText = "sacrifice any number of other permanents, then draw that many cards.";
    }

    private GodEternalBontuEffect(GodEternalBontuEffect effect) {
        super((OneShotEffect)effect);
    }

    public GodEternalBontuEffect copy() {
        return new GodEternalBontuEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(0, Integer.MAX_VALUE, (FilterPermanent)StaticFilters.FILTER_OTHER_CONTROLLED_PERMANENTS);
        if (!player.choose(this.outcome, (Target)target, source, game)) {
            return false;
        }
        int counter = 0;
        for (UUID permanentId : target.getTargets()) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null || !permanent.sacrifice(source, game)) continue;
            ++counter;
        }
        return player.drawCards(counter, source, game) > 0;
    }
}

