/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.functions.CopyTokenFunction;

class GodPharaohsGiftEffect
extends OneShotEffect {
    GodPharaohsGiftEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "you may exile a creature card from your graveyard. If you do, create a token that's a copy of that card, except it's a 4/4 black Zombie. It gains haste until end of turn";
    }

    private GodPharaohsGiftEffect(GodPharaohsGiftEffect effect) {
        super((OneShotEffect)effect);
    }

    public GodPharaohsGiftEffect copy() {
        return new GodPharaohsGiftEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD, true);
        controller.choose(Outcome.PutCreatureInPlay, (Target)target, source, game);
        Card cardChosen = game.getCard(target.getFirstTarget());
        if (cardChosen == null || !controller.moveCards(cardChosen, Zone.EXILED, source, game)) {
            return false;
        }
        Token token = CopyTokenFunction.createTokenCopy((Card)cardChosen, (Game)game);
        token.removePTCDA();
        token.setPower(4);
        token.setToughness(4);
        token.setColor(ObjectColor.BLACK);
        token.removeAllCreatureTypes();
        token.addSubType(new SubType[]{SubType.ZOMBIE});
        token.putOntoBattlefield(1, game, source, source.getControllerId());
        List permanents = token.getLastAddedTokenIds().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (!permanents.isEmpty()) {
            game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTargets(permanents, game)), source);
        }
        return true;
    }
}

