/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class GodsendExileEffect
extends OneShotEffect {
    GodsendExileEffect() {
        super(Outcome.Exile);
        this.staticText = "you may exile one of those creatures";
    }

    private GodsendExileEffect(GodsendExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public GodsendExileEffect copy() {
        return new GodsendExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (creature != null && controller != null && sourcePermanent != null) {
            UUID exileId = CardUtil.getCardExileZoneId((Game)game, (Ability)source);
            controller.moveCardToExileWithInfo((Card)creature, exileId, sourcePermanent.getIdName() + " (" + sourcePermanent.getZoneChangeCounter(game) + ')', source, game, Zone.BATTLEFIELD, true);
        }
        return false;
    }
}

