/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.g.GodsendExileEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FirstTargetPointer;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GodsendTriggeredAbility
extends TriggeredAbilityImpl {
    private Set<UUID> possibleTargets = new HashSet<UUID>();

    GodsendTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GodsendExileEffect(), true);
    }

    private GodsendTriggeredAbility(GodsendTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public GodsendTriggeredAbility copy() {
        return new GodsendTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_BLOCKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent equippedPermanent;
        Permanent equipment = game.getPermanentOrLKIBattlefield(this.getSourceId());
        if (equipment != null && equipment.getAttachedTo() != null && (equippedPermanent = game.getPermanentOrLKIBattlefield(equipment.getAttachedTo())) != null) {
            this.possibleTargets.clear();
            String targetName = "";
            if (equippedPermanent.isAttacking()) {
                for (CombatGroup group : game.getCombat().getGroups()) {
                    if (!group.getAttackers().contains(equippedPermanent.getId())) continue;
                    this.possibleTargets.addAll(group.getBlockers());
                }
                targetName = "a creature blocking attacker ";
            } else if (equippedPermanent.getBlocking() > 0) {
                for (CombatGroup group : game.getCombat().getGroups()) {
                    if (!group.getBlockers().contains(equippedPermanent.getId())) continue;
                    this.possibleTargets.addAll(group.getAttackers());
                }
                targetName = "a creature blocked by creature ";
            }
            if (!this.possibleTargets.isEmpty()) {
                this.getTargets().clear();
                if (this.possibleTargets.size() == 1) {
                    ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(this.possibleTargets.iterator().next(), game));
                } else {
                    ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FirstTargetPointer());
                    targetName = targetName + " equipped by " + equipment.getName();
                    FilterCreaturePermanent filter = new FilterCreaturePermanent(targetName);
                    ArrayList<PermanentIdPredicate> uuidPredicates = new ArrayList<PermanentIdPredicate>();
                    for (UUID creatureId : this.possibleTargets) {
                        uuidPredicates.add(new PermanentIdPredicate(creatureId));
                    }
                    filter.add(Predicates.or(uuidPredicates));
                    this.getTargets().add((Target)new TargetPermanent((FilterPermanent)filter));
                }
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever equipped creature blocks or becomes blocked by one or more creatures, you may exile one of those creatures.";
    }
}

