/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class GoldenGuardianReturnTransformedEffect
extends OneShotEffect {
    GoldenGuardianReturnTransformedEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "return it to the battlefield transformed under your control";
    }

    private GoldenGuardianReturnTransformedEffect(GoldenGuardianReturnTransformedEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoldenGuardianReturnTransformedEffect copy() {
        return new GoldenGuardianReturnTransformedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || game.getState().getZone(source.getSourceId()) != Zone.GRAVEYARD) {
            return false;
        }
        game.getState().setValue("EnterTransformed" + source.getSourceId(), (Object)Boolean.TRUE);
        Card card = game.getCard(source.getSourceId());
        return card != null && controller.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

