/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class GoldnightCastigatorDoubleDamageEffect
extends ReplacementEffectImpl {
    GoldnightCastigatorDoubleDamageEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If a source would deal damage to you, it deals double that damage to you instead.<br>If a source would deal damage to {this}, it deals double that damage to {this} instead.";
    }

    private GoldnightCastigatorDoubleDamageEffect(GoldnightCastigatorDoubleDamageEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public GoldnightCastigatorDoubleDamageEffect copy() {
        return new GoldnightCastigatorDoubleDamageEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT || event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        switch (event.getType()) {
            case DAMAGE_PLAYER: {
                if (!event.getTargetId().equals(source.getControllerId())) break;
                event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
                break;
            }
            case DAMAGE_PERMANENT: {
                Permanent permanent = game.getPermanent(event.getTargetId());
                if (permanent == null || !permanent.getId().equals(source.getSourceId())) break;
                event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
            }
        }
        return false;
    }
}

