/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.g.BlockedByWatcher;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GomazoaEffect
extends OneShotEffect {
    GomazoaEffect() {
        super(Outcome.Neutral);
        this.staticText = "Put {this} and each creature it's blocking on top of their owners' libraries, then those players shuffle";
    }

    private GomazoaEffect(GomazoaEffect effect) {
        super((OneShotEffect)effect);
    }

    public GomazoaEffect copy() {
        return new GomazoaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ArrayList<UUID> players = new ArrayList<UUID>();
            Permanent gomazoa = game.getPermanent(source.getSourceId());
            if (gomazoa != null) {
                controller.moveCardToLibraryWithInfo((Card)gomazoa, source, game, Zone.BATTLEFIELD, true, true);
                players.add(gomazoa.getOwnerId());
            }
            BlockedByWatcher watcher = (BlockedByWatcher)game.getState().getWatcher(BlockedByWatcher.class, source.getSourceId());
            for (UUID blockedById : watcher.getBlockedByWatcher()) {
                Permanent blockedByGomazoa = game.getPermanent(blockedById);
                if (blockedByGomazoa == null || !blockedByGomazoa.isAttacking()) continue;
                players.add(blockedByGomazoa.getOwnerId());
                Player owner = game.getPlayer(blockedByGomazoa.getOwnerId());
                if (owner == null) continue;
                owner.moveCardToLibraryWithInfo((Card)blockedByGomazoa, source, game, Zone.BATTLEFIELD, true, true);
            }
            for (UUID player : players) {
                Player owner = game.getPlayer(player);
                if (owner == null) continue;
                owner.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }
}

