/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileFaceDownYouMayPlayAsLongAsExiledTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CastManaAdjustment;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GontiLordOfLuxuryEffect
extends OneShotEffect {
    public GontiLordOfLuxuryEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top four cards of target opponent's library, exile one of them face down, then put the rest on the bottom of that library in a random order. You may cast that card for as long as it remains exiled, and mana of any type can be spent to cast it";
    }

    private GontiLordOfLuxuryEffect(GontiLordOfLuxuryEffect effect) {
        super((OneShotEffect)effect);
    }

    public GontiLordOfLuxuryEffect copy() {
        return new GontiLordOfLuxuryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || opponent == null || sourceObject == null) {
            return false;
        }
        CardsImpl topCards = new CardsImpl();
        topCards.addAllCards((Collection)opponent.getLibrary().getTopCards(game, 4));
        TargetCard target = new TargetCard(Zone.LIBRARY, new FilterCard("card to exile"));
        controller.choose(this.outcome, (Cards)topCards, target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            new ExileFaceDownYouMayPlayAsLongAsExiledTargetEffect(true, CastManaAdjustment.AS_THOUGH_ANY_MANA_TYPE).setTargetPointer((TargetPointer)new FixedTarget(card, game)).apply(game, source);
        }
        topCards.retainZone(Zone.LIBRARY, game);
        controller.putCardsOnBottomOfLibrary((Cards)topCards, game, source, false);
        return true;
    }
}

