/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TreasureToken;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GontiSpellTriggeredAbility
extends TriggeredAbilityImpl {
    public GontiSpellTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenTargetEffect((Token)new TreasureToken()), false);
        this.setTriggerPhrase("Whenever a player casts a spell they don't own, ");
    }

    private GontiSpellTriggeredAbility(GontiSpellTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public GontiSpellTriggeredAbility copy() {
        return new GontiSpellTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player player = game.getPlayer(event.getPlayerId());
        Spell spell = game.getSpell(event.getTargetId());
        if (player != null && spell != null && !player.getId().equals(spell.getOwnerId())) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(player.getId()));
            return true;
        }
        return false;
    }
}

