/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileXFromYourGraveCost;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class GorexTheTombshellCostReductionEffect
extends CostModificationEffectImpl {
    GorexTheTombshellCostReductionEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit, CostModificationType.REDUCE_COST);
    }

    private GorexTheTombshellCostReductionEffect(GorexTheTombshellCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        SpellAbility spellAbility = (SpellAbility)abilityToModify;
        for (Cost cost : spellAbility.getCosts()) {
            if (!(cost instanceof ExileXFromYourGraveCost)) continue;
            if (game.inCheckPlayableState()) {
                int reduction = ((ExileXFromYourGraveCost)cost).getMaxValue((Ability)spellAbility, game);
                CardUtil.adjustCost((SpellAbility)spellAbility, (int)(reduction * 2));
                break;
            }
            int reduction = ((ExileXFromYourGraveCost)cost).getAmount();
            CardUtil.adjustCost((SpellAbility)spellAbility, (int)(reduction * 2));
            break;
        }
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && abilityToModify.getSourceId().equals(source.getSourceId());
    }

    public GorexTheTombshellCostReductionEffect copy() {
        return new GorexTheTombshellCostReductionEffect(this);
    }
}

