/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class GrafdiggersCageEffect
extends ContinuousRuleModifyingEffectImpl {
    GrafdiggersCageEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Creature cards in graveyards and libraries can't enter the battlefield";
    }

    private GrafdiggersCageEffect(GrafdiggersCageEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public GrafdiggersCageEffect copy() {
        return new GrafdiggersCageEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return GameEvent.EventType.ZONE_CHANGE == event.getType();
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card card;
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.getToZone() == Zone.BATTLEFIELD && (zEvent.getFromZone() == Zone.GRAVEYARD || zEvent.getFromZone() == Zone.LIBRARY) && (card = game.getCard(zEvent.getTargetId())) != null && card.isCreature(game);
    }
}

