/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.GrakmawSkyclaveRavagerHydraToken;

class GrakmawSkyclaveRavagerEffect
extends OneShotEffect {
    GrakmawSkyclaveRavagerEffect() {
        super(Outcome.Benefit);
        this.staticText = "create an X/X black and green Hydra creature token, where X is the number of +1/+1 counters on {this}";
    }

    private GrakmawSkyclaveRavagerEffect(GrakmawSkyclaveRavagerEffect effect) {
        super((OneShotEffect)effect);
    }

    public GrakmawSkyclaveRavagerEffect copy() {
        return new GrakmawSkyclaveRavagerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int counters = 0;
        Permanent permanent = (Permanent)this.getValue("permanentLeftBattlefield");
        if (permanent != null) {
            counters = permanent.getCounters(game).getCount(CounterType.P1P1);
        }
        return new GrakmawSkyclaveRavagerHydraToken(counters).putOntoBattlefield(1, game, source, source.getControllerId());
    }
}

