/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Arrays;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ColoredManaSymbol;
import mage.constants.MultiAmountType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class GrandWarlordRadhaEffect
extends OneShotEffect {
    GrandWarlordRadhaEffect() {
        super(Outcome.PutManaInPool);
        this.staticText = "add that much mana in any combination of {R} and/or {G}. Until end of turn, you don't lose this mana as steps and phases end";
    }

    private GrandWarlordRadhaEffect(GrandWarlordRadhaEffect effect) {
        super((OneShotEffect)effect);
    }

    public GrandWarlordRadhaEffect copy() {
        return new GrandWarlordRadhaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        int amount = (Integer)this.getValue("number_attackers");
        if (controller == null || amount < 1) {
            return false;
        }
        List manaList = controller.getMultiAmount(this.outcome, Arrays.asList("R", "G"), 0, amount, amount, MultiAmountType.MANA, game);
        Mana mana = new Mana();
        mana.add(new Mana(ColoredManaSymbol.R, ((Integer)manaList.get(0)).intValue()));
        mana.add(new Mana(ColoredManaSymbol.G, ((Integer)manaList.get(1)).intValue()));
        controller.getManaPool().addMana(mana, game, source, true);
        return true;
    }
}

