/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GrapplingHookEffect
extends RequirementEffect {
    GrapplingHookEffect() {
        this(Duration.EndOfTurn);
    }

    public GrapplingHookEffect(Duration duration) {
        super(duration);
        this.staticText = "target creature block it this turn if able";
    }

    private GrapplingHookEffect(GrapplingHookEffect effect) {
        super((RequirementEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        Permanent equipment;
        if (permanent.getId().equals(source.getFirstTarget()) && (equipment = game.getPermanent(source.getSourceId())) != null && equipment.getAttachedTo() != null) {
            return permanent.canBlock(equipment.getAttachedTo(), game);
        }
        return false;
    }

    public boolean mustAttack(Game game) {
        return false;
    }

    public boolean mustBlock(Game game) {
        return true;
    }

    public UUID mustBlockAttacker(Ability source, Game game) {
        Permanent attachment = game.getPermanent(source.getSourceId());
        return attachment != null ? attachment.getAttachedTo() : null;
    }

    public GrapplingHookEffect copy() {
        return new GrapplingHookEffect(this);
    }
}

