/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.cards.g.GraveBetrayalEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GraveBetrayalTriggeredAbility
extends TriggeredAbilityImpl {
    public GraveBetrayalTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private GraveBetrayalTriggeredAbility(GraveBetrayalTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public GraveBetrayalTriggeredAbility copy() {
        return new GraveBetrayalTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Card card;
        Permanent permanent;
        ZoneChangeEvent zoneChangeEvent = (ZoneChangeEvent)event;
        if (zoneChangeEvent.isDiesEvent() && (permanent = (Permanent)game.getLastKnownInformation(event.getTargetId(), Zone.BATTLEFIELD)) != null && !permanent.isControlledBy(this.getControllerId()) && permanent.isCreature(game) && (card = (Card)game.getObject(permanent.getId())) != null) {
            GraveBetrayalEffect effect = new GraveBetrayalEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
            AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, (Ability)this);
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature you don't control dies, return it to the battlefield under your control with an additional +1/+1 counter on it at the beginning of the next end step. That creature is a black Zombie in addition to its other colors and types.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

