/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class GraveBirthingEffect
extends OneShotEffect {
    GraveBirthingEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent exiles a card from their graveyard";
    }

    private GraveBirthingEffect(GraveBirthingEffect effect) {
        super((OneShotEffect)effect);
    }

    public GraveBirthingEffect copy() {
        return new GraveBirthingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (opponent != null) {
            TargetCardInYourGraveyard target = new TargetCardInYourGraveyard();
            target.withNotTarget(true);
            opponent.chooseTarget(this.outcome, (Target)target, source, game);
            Card card = game.getCard(target.getFirstTarget());
            opponent.moveCards(card, Zone.EXILED, source, game);
            return true;
        }
        return false;
    }
}

