/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class GravestormEffect
extends OneShotEffect {
    GravestormEffect() {
        super(Outcome.Exile);
        this.staticText = "target opponent may exile a card from their graveyard. If that player doesn't, you may draw a card.";
    }

    private GravestormEffect(GravestormEffect effect) {
        super((OneShotEffect)effect);
    }

    public GravestormEffect copy() {
        return new GravestormEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (targetPlayer != null && you != null) {
            Card card;
            FilterCard filter = new FilterCard("card from your graveyard");
            filter.add((Predicate)new OwnerIdPredicate(targetPlayer.getId()));
            TargetCardInGraveyard target = new TargetCardInGraveyard(filter);
            boolean opponentChoosesExile = targetPlayer.chooseUse(Outcome.Exile, "Exile a card from your graveyard?", source, game);
            boolean opponentExilesACard = false;
            if (opponentChoosesExile && targetPlayer.chooseTarget(Outcome.Exile, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                opponentExilesACard = targetPlayer.moveCardToExileWithInfo(card, null, "", source, game, Zone.GRAVEYARD, true);
            }
            if (!opponentExilesACard && you.chooseUse(Outcome.DrawCard, "Draw a card?", source, game)) {
                you.drawCards(1, source, game);
            }
            return true;
        }
        return false;
    }
}

