/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GreatbowDoyenEffect
extends OneShotEffect {
    GreatbowDoyenEffect() {
        super(Outcome.Damage);
        this.staticText = "that Archer deals that much damage to that creature's controller";
    }

    private GreatbowDoyenEffect(GreatbowDoyenEffect effect) {
        super((OneShotEffect)effect);
    }

    public GreatbowDoyenEffect copy() {
        return new GreatbowDoyenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Integer damageAmount = (Integer)this.getValue("damageAmount");
        UUID controllerId = (UUID)this.getValue("controller");
        UUID sourceOfDamage = (UUID)this.getValue("source");
        if (damageAmount != null && controllerId != null) {
            Player player;
            Permanent permanent = game.getPermanent(sourceOfDamage);
            if (permanent == null) {
                permanent = (Permanent)game.getLastKnownInformation(sourceOfDamage, Zone.BATTLEFIELD);
            }
            if (permanent != null && (player = game.getPlayer(controllerId)) != null) {
                player.damage(damageAmount.intValue(), sourceOfDamage, source, game);
                game.informPlayers(permanent.getName() + " deals " + damageAmount + " damage to " + player.getLogName());
                return true;
            }
        }
        return false;
    }
}

