/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.BlockedByIdPredicate;
import mage.filter.predicate.permanent.BlockingAttackerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GreaterWerewolfEffect
extends OneShotEffect {
    GreaterWerewolfEffect() {
        super(Outcome.Detriment);
        this.staticText = "put a -0/-2 counter on each creature blocking or blocked by {this}";
    }

    private GreaterWerewolfEffect(GreaterWerewolfEffect effect) {
        super((OneShotEffect)effect);
    }

    public GreaterWerewolfEffect copy() {
        return new GreaterWerewolfEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (sourcePermanent != null) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add(Predicates.or((Predicate)new BlockedByIdPredicate(sourcePermanent.getId()), (Predicate)new BlockingAttackerIdPredicate(sourcePermanent.getId())));
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                AddCountersTargetEffect effect = new AddCountersTargetEffect(CounterType.M0M2.createInstance(), Outcome.UnboostCreature);
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                effect.apply(game, source);
            }
            return true;
        }
        return false;
    }
}

