/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GreenDragonDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    public GreenDragonDelayedTriggeredAbility() {
        super((Effect)new DestroyTargetEffect(), Duration.EndOfTurn, false);
    }

    private GreenDragonDelayedTriggeredAbility(GreenDragonDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public GreenDragonDelayedTriggeredAbility copy() {
        return new GreenDragonDelayedTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && permanent.isCreature(game) && game.getOpponents(permanent.getControllerId()).contains(this.getControllerId())) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "until end of turn, whenever a creature an opponent controls is dealt damage, destroy it.";
    }
}

