/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GrenzoDungeonWardenEffect
extends OneShotEffect {
    GrenzoDungeonWardenEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put the bottom card of your library into your graveyard. If it's a creature card with power less than or equal to {this}'s power, put it onto the battlefield";
    }

    private GrenzoDungeonWardenEffect(GrenzoDungeonWardenEffect effect) {
        super((OneShotEffect)effect);
    }

    public GrenzoDungeonWardenEffect copy() {
        return new GrenzoDungeonWardenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card;
            if (controller.getLibrary().hasCards() && (card = controller.getLibrary().getFromBottom(game)) != null) {
                Permanent sourcePermanent;
                controller.moveCards(card, Zone.GRAVEYARD, source, game);
                if (card.isCreature(game) && (sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId())) != null && card.getPower().getValue() <= sourcePermanent.getPower().getValue()) {
                    controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

