/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class GrenzoHavocRaiserEffect
extends OneShotEffect {
    GrenzoHavocRaiserEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "exile the top card of that player's library. Until end of turn, you may cast that card and you may spend mana as though it were mana of any color to cast that spell";
    }

    private GrenzoHavocRaiserEffect(GrenzoHavocRaiserEffect effect) {
        super((OneShotEffect)effect);
    }

    public GrenzoHavocRaiserEffect copy() {
        return new GrenzoHavocRaiserEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player damagedPlayer;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (damagedPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source))) != null) {
            MageObject sourceObject = game.getObject(source);
            UUID exileId = CardUtil.getCardExileZoneId((Game)game, (Ability)source);
            Card card = damagedPlayer.getLibrary().getFromTop(game);
            if (card != null && sourceObject != null) {
                controller.moveCardToExileWithInfo(card, exileId, sourceObject.getIdName(), source, game, Zone.LIBRARY, true);
                if (card.getSpellAbility() != null) {
                    CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.EndOfTurn, (boolean)true);
                }
            }
            return true;
        }
        return false;
    }
}

