/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GreyKnightParagonEffect
extends OneShotEffect {
    GreyKnightParagonEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy target attacking creature. If that creature is a Demon, exile it instead";
    }

    private GreyKnightParagonEffect(GreyKnightParagonEffect effect) {
        super((OneShotEffect)effect);
    }

    public GreyKnightParagonEffect copy() {
        return new GreyKnightParagonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        return player != null && permanent != null && (permanent.hasSubtype(SubType.DEMON, game) ? player.moveCards((Card)permanent, Zone.EXILED, source, game) : permanent.destroy(source, game));
    }
}

