/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class GrimCaptainsCallEffect
extends OneShotEffect {
    GrimCaptainsCallEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return a Pirate card from your graveyard to your hand, then do the same for Vampire, Dinosaur, and Merfolk";
    }

    private GrimCaptainsCallEffect(GrimCaptainsCallEffect effect) {
        super((OneShotEffect)effect);
    }

    public GrimCaptainsCallEffect copy() {
        return new GrimCaptainsCallEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            this.returnToHand(game, SubType.PIRATE, controller, source);
            this.returnToHand(game, SubType.VAMPIRE, controller, source);
            this.returnToHand(game, SubType.DINOSAUR, controller, source);
            this.returnToHand(game, SubType.MERFOLK, controller, source);
            return true;
        }
        return false;
    }

    private void returnToHand(Game game, SubType subType, Player controller, Ability source) {
        Card card;
        FilterCreatureCard filter = new FilterCreatureCard(subType.getDescription() + " card");
        filter.add((Predicate)subType.getPredicate());
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)filter);
        if (target.canChoose(source.getControllerId(), source, game) && controller.chooseTarget(this.outcome, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            controller.moveCards(card, Zone.HAND, source, game);
        }
    }
}

