/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class GrimContestEffect
extends OneShotEffect {
    GrimContestEffect() {
        super(Outcome.Damage);
        this.staticText = "Choose target creature you control and target creature an opponent controls. Each of those creatures deals damage equal to its toughness to the other";
    }

    private GrimContestEffect(GrimContestEffect effect) {
        super((OneShotEffect)effect);
    }

    public GrimContestEffect copy() {
        return new GrimContestEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent creature1 = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            Permanent creature2 = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
            if (creature1 != null && creature2 != null && creature1.isCreature(game) && creature2.isCreature(game)) {
                creature1.damage(creature2.getToughness().getValue(), creature2.getId(), source, game, false, true);
                game.informPlayers(creature2.getLogName() + " deals " + creature2.getToughness().getValue() + " damage to " + creature1.getLogName());
                creature2.damage(creature1.getToughness().getValue(), creature1.getId(), source, game, false, true);
                game.informPlayers(creature1.getLogName() + " deals " + creature1.getToughness().getValue() + " damage to " + creature2.getLogName());
            }
            return true;
        }
        return false;
    }
}

