/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.g.GrimReminderWatcher;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class GrimReminderEffect
extends OneShotEffect {
    GrimReminderEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library for a nonland card and reveal it. Each opponent who cast a spell this turn with the same name as that card loses 6 life. Then shuffle.";
    }

    private GrimReminderEffect(GrimReminderEffect effect) {
        super((OneShotEffect)effect);
    }

    public GrimReminderEffect copy() {
        return new GrimReminderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            Card card;
            TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)StaticFilters.FILTER_CARD_NON_LAND);
            if (controller.searchLibrary(target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                CardsImpl cardsToReveal = new CardsImpl(card);
                controller.revealCards(sourceObject.getIdName(), (Cards)cardsToReveal, game);
                String cardName = card.getName();
                GrimReminderWatcher watcher = (GrimReminderWatcher)game.getState().getWatcher(GrimReminderWatcher.class);
                if (watcher != null) {
                    for (UUID playerId : watcher.getPlayersCastSpell(cardName)) {
                        Player player = game.getPlayer(playerId);
                        if (player == null) continue;
                        player.loseLife(6, game, source, false);
                    }
                }
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }
}

