/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import java.util.Set;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.cards.SplitCard;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.util.CardUtil;

class GrimoireThiefCounterspellEffect
extends OneShotEffect {
    GrimoireThiefCounterspellEffect() {
        super(Outcome.Discard);
        this.staticText = "Turn all cards exiled with {this} face up. Counter all spells with those names";
    }

    private GrimoireThiefCounterspellEffect(GrimoireThiefCounterspellEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        CardsImpl cards = new CardsImpl();
        MageObject sourceObject = game.getObject(source);
        Set exileZones = (Set)game.getState().getValue("ExileZones" + source.getSourceId().toString());
        if (exileZones != null && sourceObject != null) {
            for (ExileZone exileZone : game.getExile().getExileZones()) {
                if (exileZone.isEmpty()) continue;
                cards.addAllCards((Collection)exileZone.getCards(game));
            }
            for (Card card : cards.getCards(game)) {
                card.setFaceDown(false, game);
            }
            for (Card card : cards.getCards(game)) {
                for (StackObject stackObject : game.getStack()) {
                    String name2;
                    String name1;
                    MageObject mageObject = game.getObject(card.getId());
                    if (mageObject instanceof SplitCard) {
                        name1 = ((SplitCard)mageObject).getLeftHalfCard().getName();
                        name2 = ((SplitCard)mageObject).getRightHalfCard().getName();
                    } else {
                        name2 = name1 = mageObject.getName();
                    }
                    if (!CardUtil.haveSameNames((MageObject)stackObject, (String)name1, (Game)game) && !CardUtil.haveSameNames((MageObject)stackObject, (String)name2, (Game)game)) continue;
                    Spell spell = (Spell)stackObject;
                    game.getStack().counter(stackObject.getId(), source, game);
                    game.informPlayers(sourceObject.getLogName() + ": spell " + spell.getIdName() + " was countered.");
                }
            }
            return true;
        }
        return false;
    }

    public GrimoireThiefCounterspellEffect copy() {
        return new GrimoireThiefCounterspellEffect(this);
    }
}

