/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class GrimoireThiefExileEffect
extends OneShotEffect {
    GrimoireThiefExileEffect() {
        super(Outcome.Discard);
        this.staticText = "exile the top three cards of target opponent's library face down";
    }

    private GrimoireThiefExileEffect(GrimoireThiefExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player targetOpponent = game.getPlayer(source.getFirstTarget());
        if (targetOpponent != null) {
            Set cards = targetOpponent.getLibrary().getTopCards(game, 3);
            MageObject sourceObject = source.getSourceObject(game);
            if (!cards.isEmpty() && sourceObject != null) {
                for (Object card : cards) {
                    card.setFaceDown(true, game);
                }
                UUID exileZoneId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
                targetOpponent.moveCardsToExile(cards, source, game, false, exileZoneId, sourceObject.getIdName());
                for (Card card : cards) {
                    card.setFaceDown(true, game);
                }
                HashSet<UUID> exileZones = (HashSet<UUID>)game.getState().getValue("ExileZones" + source.getSourceId().toString());
                if (exileZones == null) {
                    exileZones = new HashSet<UUID>();
                    game.getState().setValue("ExileZones" + source.getSourceId().toString(), exileZones);
                }
                exileZones.add(exileZoneId);
                return true;
            }
        }
        return false;
    }

    public GrimoireThiefExileEffect copy() {
        return new GrimoireThiefExileEffect(this);
    }
}

