/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.g.GrinningTotemPutIntoGraveyardEffect;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.events.GameEvent;

class GrinningTotemDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final UUID exileZoneId;

    public GrinningTotemDelayedTriggeredAbility(UUID exileZoneId) {
        super((Effect)new GrinningTotemPutIntoGraveyardEffect(exileZoneId));
        this.exileZoneId = exileZoneId;
    }

    private GrinningTotemDelayedTriggeredAbility(GrinningTotemDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.exileZoneId = ability.exileZoneId;
    }

    public boolean checkInterveningIfClause(Game game) {
        ExileZone exileZone = game.getExile().getExileZone(this.exileZoneId);
        return exileZone != null && !exileZone.getCards(game).isEmpty();
    }

    public GrinningTotemDelayedTriggeredAbility copy() {
        return new GrinningTotemDelayedTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UPKEEP_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return game.isActivePlayer(this.getControllerId());
    }

    public String getRule() {
        return "At the beginning of your next upkeep, if you haven't played it, put it into its owner's graveyard.";
    }
}

