/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.IzoniInsectToken;
import mage.players.Player;

class GristTheHungerTideTokenEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    GristTheHungerTideTokenEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a 1/1 black and green Insect creature token, then mill a card. If an Insect card was milled this way, put a loyalty counter on {this} and repeat this process";
    }

    private GristTheHungerTideTokenEffect(GristTheHungerTideTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public GristTheHungerTideTokenEffect copy() {
        return new GristTheHungerTideTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        IzoniInsectToken token = new IzoniInsectToken();
        while (true) {
            token.putOntoBattlefield(1, game, source, source.getControllerId());
            if (player.millCards(1, source, game).count(filter, game) < 1) break;
            if (permanent == null) continue;
            permanent.addCounters(CounterType.LOYALTY.createInstance(), source.getControllerId(), source, game);
        }
        return true;
    }

    static {
        filter.add((Predicate)SubType.INSECT.getPredicate());
    }
}

