/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Set;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;

class GristThePlagueSwarmMinus6Effect
extends OneShotEffect {
    GristThePlagueSwarmMinus6Effect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "For each creature card in your graveyard, create a token that's a copy of it, except it's a 1/1 black and green Insect.";
    }

    private GristThePlagueSwarmMinus6Effect(GristThePlagueSwarmMinus6Effect effect) {
        super((OneShotEffect)effect);
    }

    public GristThePlagueSwarmMinus6Effect copy() {
        return new GristThePlagueSwarmMinus6Effect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Set cards = controller.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game);
        if (cards.isEmpty()) {
            return false;
        }
        for (Card card : cards) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(null, null, false, 1, false, false, null, 1, 1, false);
            effect.setSavedPermanent((Permanent)new PermanentCard(card, controller.getId(), game));
            effect.setOnlyColor(new ObjectColor("BG"));
            effect.setOnlySubType(SubType.INSECT);
            effect.apply(game, source);
        }
        return true;
    }
}

